<?php
// Seed script: creates schema, an admin user and sample data
require_once __DIR__ . '/config/db.php';

// Load schema
$sql = file_get_contents(__DIR__ . '/db_schema.sql');
$pdo->exec($sql);

// Create admin user
$ADMIN_EMAIL = 'admin@plansoil.local';
$ADMIN_PASSWORD = 'Admin@123';

$stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
$stmt->execute([$ADMIN_EMAIL]);
if (!$stmt->fetch()) {
    $hash = password_hash($ADMIN_PASSWORD, PASSWORD_BCRYPT);
    $pdo->prepare("INSERT INTO users (name, email, phone, password_hash, role, status, created_at) VALUES ('Super Admin', ?, '9999999999', ?, 'super_admin', 'active', NOW())")
        ->execute([$ADMIN_EMAIL, $hash]);
}

// Sample categories
$pdo->exec("INSERT IGNORE INTO categories (id, name, description, is_active) VALUES
    (1, 'Seeds', 'Certified seeds for major crops.', 1),
    (2, 'Fertilizers', 'Nutrient management inputs.', 1),
    (3, 'Tools', 'Basic hand tools for farm operations.', 1),
    (4, 'Soil Amendments', 'Lime, gypsum, organic matter.', 1)
");

// Sample products
$pdo->exec("INSERT IGNORE INTO products (id, category_id, title, sku, price, mrp, unit, image, description, stock, min_stock, is_active, created_at) VALUES
    (1, 1, 'Wheat Foundation Seed – HD 2967', 'SEED-WHEAT-HD2967', 1200.00, 1350.00, 'kg', '', 'High yielding wheat seed suitable for loam soil with timely irrigation.', 50, 10, 1, NOW()),
    (2, 1, 'Paddy Hybrid Seed – RH 1531', 'SEED-PADDY-RH1531', 1500.00, 1650.00, 'kg', '', 'Hybrid paddy seed with good disease resistance for Kharif season.', 40, 8, 1, NOW()),
    (3, 2, 'NPK 10:26:26 Complex Fertilizer', 'FERT-NPK-10-26-26', 950.00, 1100.00, '50 kg bag', '', 'Balanced starter fertiliser ideal for basal dose in wheat and mustard.', 60, 12, 1, NOW()),
    (4, 2, 'Urea 46% N', 'FERT-UREA-46', 300.00, 350.00, '45 kg bag', '', 'Nitrogen rich fertiliser for top-dressing in cereals.', 100, 20, 1, NOW()),
    (5, 4, 'Agricultural Lime Powder', 'SOIL-LIME', 450.00, 520.00, '25 kg bag', '', 'Reduces soil acidity and improves pH for most crops.', 30, 5, 1, NOW())
");

// Sample soil types
$pdo->exec("INSERT IGNORE INTO soil_types (id, name, ph_min, ph_max, texture, drainage, recommended_crops, description) VALUES
    (1, 'Loam', 6.0, 7.5, 'Medium', 'Well drained', 'Wheat, Mustard, Pulses, Vegetables', 'Balanced mixture of sand, silt and clay with good fertility.'),
    (2, 'Clay', 6.5, 8.0, 'Heavy', 'Poor to moderate', 'Paddy, Sugarcane', 'Fine-textured soil with good nutrient holding capacity but may have drainage issues.'),
    (3, 'Sandy Loam', 5.8, 7.0, 'Light', 'Well drained', 'Groundnut, Vegetables, Millets', 'Light textured soil with good drainage; needs frequent irrigation and organic matter.')
");

// Sample advisory rules
$pdo->exec("INSERT IGNORE INTO advisory_rules (id, soil_type_id, season, ph_min, ph_max, recommended_crops, seed_rate, sowing_window, fertilization_schedule, organic_amendments, pest_watchlist, is_active) VALUES
    (1, 1, 'Rabi', 6.0, 7.5, 'Wheat, Mustard', 'Wheat: 100–125 kg/ha; Mustard: 4–5 kg/ha', 'Sowing window: early Nov to late Nov for North India.', 'Basal: NPK 10:26:26 @ 150–200 kg/ha at sowing; Top dressing: Urea split in 2 doses at tillering and booting.', 'Add 5–10 t/ha of well decomposed FYM before last ploughing to improve soil structure.', 'Wheat: rust, smut; Mustard: aphids – monitor crop after 30–35 days of sowing.', 1),
    (2, 2, 'Kharif', 6.5, 8.0, 'Paddy (HYV/Hybrid)', 'Paddy: 20–25 kg/acre (line sowing) or as per nursery.', 'Transplanting: 20–25 days old seedlings; June–July depending on monsoon.', 'Basal: NPK 10:26:26 @ recommended dose; Top dressing: split urea doses at tillering and panicle initiation.', 'Incorporate green manure or FYM 2–3 weeks before puddling to improve soil tilth.', 'Stem borer, leaf folder, blast – regular field scouting at weekly intervals.', 1)
");

// Sample knowledge articles
$pdo->exec("INSERT IGNORE INTO knowledge_articles (id, title, type, content, status, created_at) VALUES
    (1, 'Basics of Soil pH and Liming', 'article', 'Soil pH strongly influences nutrient availability. Most field crops perform best between pH 6.0 and 7.5. When pH is lower than 6.0, liming materials like agricultural lime are used to raise pH.', 'published', NOW()),
    (2, 'Recommended Sowing Window for Wheat in North India', 'article', 'Timely sowing of wheat ensures better tillering and yield. For timely sown wheat, first fortnight of November is considered ideal in many irrigated regions.', 'published', NOW()),
    (3, 'Loam Soil – Ideal Properties', 'soil', 'Loam soil has a balanced mixture of sand, silt and clay particles. It is considered ideal for many crops because of good water retention as well as drainage.', 'published', NOW()),
    (4, 'Wheat – HD 2967 Variety Snapshot', 'crop', 'HD 2967 is a popular high yielding wheat variety with good tillering and disease resistance under proper management.', 'published', NOW())
");

echo "Seed completed. Admin login: $ADMIN_EMAIL / $ADMIN_PASSWORD";
