<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

if (empty($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}
$userId = $_SESSION['user']['id'];
$errors = [];
$success = '';

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$userId]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $village = trim($_POST['village'] ?? '');
    $taluk = trim($_POST['taluk'] ?? '');
    $district = trim($_POST['district'] ?? '');
    $state = trim($_POST['state'] ?? '');
    $pincode = trim($_POST['pincode'] ?? '');
    if ($name === '') $errors[] = 'Name is required.';
    if (!$errors) {
        $upd = $pdo->prepare("UPDATE users SET name=?, phone=?, village=?, taluk=?, district=?, state=?, pincode=? WHERE id=?");
        $upd->execute([$name, $phone, $village, $taluk, $district, $state, $pincode, $userId]);
        $_SESSION['user']['name'] = $name;
        $success = 'Profile updated.';
        $stmt->execute([$userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>
<div class="container my-4" style="max-width: 720px;">
    <h3 class="mb-3">My Profile</h3>
    <?php if ($success): ?><div class="alert alert-success"><?= htmlspecialchars($success) ?></div><?php endif; ?>
    <?php if ($errors): ?>
        <div class="alert alert-danger">
            <?php foreach ($errors as $e): ?><div><?= htmlspecialchars($e) ?></div><?php endforeach; ?>
        </div>
    <?php endif; ?>
    <form method="post" class="card shadow-sm p-3">
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Full Name</label>
                <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($user['name'] ?? '') ?>" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">Email (read-only)</label>
                <input type="email" class="form-control" value="<?= htmlspecialchars($user['email'] ?? '') ?>" disabled>
            </div>
            <div class="col-md-6">
                <label class="form-label">Phone</label>
                <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($user['phone'] ?? '') ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">Village</label>
                <input type="text" name="village" class="form-control" value="<?= htmlspecialchars($user['village'] ?? '') ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Taluk</label>
                <input type="text" name="taluk" class="form-control" value="<?= htmlspecialchars($user['taluk'] ?? '') ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">District</label>
                <input type="text" name="district" class="form-control" value="<?= htmlspecialchars($user['district'] ?? '') ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">State</label>
                <input type="text" name="state" class="form-control" value="<?= htmlspecialchars($user['state'] ?? '') ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Pincode</label>
                <input type="text" name="pincode" class="form-control" value="<?= htmlspecialchars($user['pincode'] ?? '') ?>">
            </div>
        </div>
        <button class="btn btn-success mt-3" type="submit">Save Changes</button>
    </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
