<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$stmt = $pdo->prepare("SELECT p.*, c.name AS category_name 
    FROM products p 
    LEFT JOIN categories c ON c.id = p.category_id 
    WHERE p.id = ?");
$stmt->execute([$id]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$product) {
    echo "<div class='container my-5'><div class='alert alert-warning'>Product not found.</div></div>";
    include __DIR__ . '/partials/footer.php';
    exit;
}
?>
<div class="container my-4">
    <div class="row g-4">
        <div class="col-md-5">
            <?php if (!empty($product['image'])): ?>
                <img src="uploads/products/<?= htmlspecialchars($product['image']) ?>" class="img-fluid rounded shadow-sm" alt="<?= htmlspecialchars($product['title']) ?>">
            <?php else: ?>
                <div class="ratio ratio-4x3 bg-light d-flex align-items-center justify-content-center text-muted rounded shadow-sm">
                    <i class="bi bi-image fs-1"></i>
                </div>
            <?php endif; ?>
        </div>
        <div class="col-md-7">
            <h3><?= htmlspecialchars($product['title']) ?></h3>
            <p class="text-muted mb-1"><?= htmlspecialchars($product['category_name'] ?? 'Input') ?></p>
            <p><?= nl2br(htmlspecialchars($product['description'])) ?></p>
            <div class="mb-3">
                <span class="fs-4 fw-bold text-success">₹<?= number_format($product['price'], 2) ?></span>
                <?php if (!empty($product['mrp']) && $product['mrp'] > $product['price']): ?>
                    <small class="text-muted text-decoration-line-through ms-1">₹<?= number_format($product['mrp'], 2) ?></small>
                <?php endif; ?>
                <span class="ms-2 small text-muted"><?= htmlspecialchars($product['unit']) ?></span>
            </div>
            <form method="post" action="cart.php">
                <input type="hidden" name="product_id" value="<?= $product['id'] ?>">
                <div class="row g-2 align-items-center">
                    <div class="col-auto">
                        <label class="form-label mb-0 small">Quantity</label>
                    </div>
                    <div class="col-auto">
                        <input type="number" name="qty" value="1" min="1" class="form-control form-control-sm" style="width: 90px;">
                    </div>
                    <div class="col-auto">
                        <button class="btn btn-success btn-sm" type="submit" name="add_to_cart">
                            <i class="bi bi-cart-plus me-1"></i>Add to Cart
                        </button>
                    </div>
                </div>
                <p class="small text-muted mt-2"><i class="bi bi-cash-coin me-1"></i>Cash on Delivery only (demo).</p>
            </form>
        </div>
    </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
