<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

$type = $_GET['type'] ?? 'article';
$stmt = $pdo->prepare("SELECT * FROM knowledge_articles WHERE status = 'published' AND type = ? ORDER BY created_at DESC");
$stmt->execute([$type]);
$articles = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="container my-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <h3 class="mb-0">Knowledge Base</h3>
            <p class="text-muted mb-0 small">Crop library, soil types and practical guides for farmers.</p>
        </div>
        <div>
            <a href="knowledge.php?type=article" class="btn btn-sm <?= $type==='article'?'btn-success':'btn-outline-success' ?>">Articles</a>
            <a href="knowledge.php?type=crop" class="btn btn-sm <?= $type==='crop'?'btn-success':'btn-outline-success' ?>">Crops</a>
            <a href="knowledge.php?type=soil" class="btn btn-sm <?= $type==='soil'?'btn-success':'btn-outline-success' ?>">Soils</a>
        </div>
    </div>
    <div class="row g-3">
        <?php foreach ($articles as $a): ?>
            <div class="col-md-6">
                <div class="card shadow-sm h-100">
                    <div class="card-body">
                        <h5 class="card-title"><?= htmlspecialchars($a['title']) ?></h5>
                        <p class="card-text small text-muted"><?= htmlspecialchars(mb_strimwidth(strip_tags($a['content']), 0, 160, '…')) ?></p>
                        <button class="btn btn-link btn-sm p-0" type="button" data-bs-toggle="collapse" data-bs-target="#art<?= $a['id'] ?>">Read more</button>
                        <div class="collapse mt-2" id="art<?= $a['id'] ?>">
                            <div class="border-top pt-2 small">
                                <?= nl2br(htmlspecialchars($a['content'])) ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <?php if (!$articles): ?>
            <p class="text-muted">No knowledge articles yet – run seed.php to add sample data.</p>
        <?php endif; ?>
    </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
