<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

if (empty($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}
$userId = $_SESSION['user']['id'];

if (empty($_SESSION['cart'])) {
    echo "<div class='container my-4'><div class='alert alert-warning'>Cart is empty.</div></div>";
    include __DIR__ . '/partials/footer.php'; exit;
}

// Fetch addresses
$addrStmt = $pdo->prepare("SELECT * FROM addresses WHERE user_id = ? ORDER BY is_default DESC, id DESC");
$addrStmt->execute([$userId]);
$addresses = $addrStmt->fetchAll(PDO::FETCH_ASSOC);

$errors = [];
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $addressId = (int)($_POST['address_id'] ?? 0);
    $deliveryWindow = trim($_POST['delivery_window'] ?? '');
    $orderNotes = trim($_POST['order_notes'] ?? '');
    if (!$addressId) $errors[] = 'Please select delivery address.';

    // build order
    if (!$errors) {
        $cart = $_SESSION['cart'];
        $ids = implode(',', array_map('intval', array_keys($cart)));
        $stmt = $pdo->query("SELECT * FROM products WHERE id IN ($ids)");
        $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $map = [];
        foreach ($products as $p) $map[$p['id']] = $p;
        $total = 0;
        foreach ($cart as $pid => $qty) {
            if (!isset($map[$pid])) continue;
            $total += $map[$pid]['price'] * $qty;
        }
        if ($total <= 0) $errors[] = 'Cart total invalid. Run seed.php first if using fresh DB.';

        if (!$errors) {
            $pdo->beginTransaction();
            $o = $pdo->prepare("INSERT INTO orders (user_id, address_id, total_amount, cod_amount, status, notes, delivery_window, created_at) VALUES (?,?,?,?, 'Pending', ?, ?, NOW())");
            $o->execute([$userId, $addressId, $total, $total, $orderNotes, $deliveryWindow]);
            $orderId = $pdo->lastInsertId();
            $oi = $pdo->prepare("INSERT INTO order_items (order_id, product_id, qty, price) VALUES (?,?,?,?)");
            foreach ($cart as $pid => $qty) {
                if (!isset($map[$pid])) continue;
                $oi->execute([$orderId, $pid, $qty, $map[$pid]['price']]);
            }
            $pdo->commit();
            $_SESSION['cart'] = [];
            header('Location: order_success.php?id=' . $orderId);
            exit;
        }
    }
}
?>
<div class="container my-4">
    <h3 class="mb-3">Checkout – Cash on Delivery</h3>
    <?php if ($errors): ?>
        <div class="alert alert-danger"><?php foreach ($errors as $e) echo "<div>".htmlspecialchars($e)."</div>"; ?></div>
    <?php endif; ?>
    <form method="post" class="row g-4">
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="mb-3">Select Address</h5>
                    <?php if (!$addresses): ?>
                        <p class="small text-muted">No address found. Please add one from Profile page (not fully implemented in this demo).</p>
                    <?php else: ?>
                        <?php foreach ($addresses as $addr): ?>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="radio" name="address_id" value="<?= $addr['id'] ?>" id="addr<?= $addr['id'] ?>" <?= $addr['is_default'] ? 'checked' : '' ?>>
                                <label class="form-check-label" for="addr<?= $addr['id'] ?>">
                                    <?= htmlspecialchars($addr['line1'] . ', ' . $addr['village'] . ', ' . $addr['district'] . ' - ' . $addr['pincode']) ?>
                                    <?php if ($addr['is_default']): ?><span class="badge bg-success ms-2">Default</span><?php endif; ?>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    <div class="mb-3 mt-2">
                        <label class="form-label">Preferred Delivery Window (text)</label>
                        <input type="text" name="delivery_window" class="form-control" placeholder="e.g., Morning slot, within 3–5 days">
                    </div>
                    <div class="mb-0">
                        <label class="form-label">Order Notes (optional)</label>
                        <textarea name="order_notes" class="form-control" rows="2"></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="mb-3">Payment Summary</h5>
                    <?php
                    $cart = $_SESSION['cart'];
                    $ids = implode(',', array_map('intval', array_keys($cart)));
                    $total = 0;
                    if ($ids) {
                        $stmt = $pdo->query("SELECT * FROM products WHERE id IN ($ids)");
                        $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        $map = [];
                        foreach ($products as $p) $map[$p['id']] = $p;
                        foreach ($cart as $pid => $qty) {
                            if (!isset($map[$pid])) continue;
                            $total += $map[$pid]['price'] * $qty;
                        }
                    }
                    ?>
                    <p class="mb-1">Items Total: <strong>₹<?= number_format($total, 2) ?></strong></p>
                    <p class="mb-1">Delivery: <strong>₹0.00</strong> (demo)</p>
                    <hr>
                    <p class="fs-5">Payable at Delivery: <strong>₹<?= number_format($total, 2) ?></strong></p>
                    <p class="small text-muted"><i class="bi bi-cash-coin me-1"></i>Cash on Delivery only – no online payment in this project.</p>
                    <button class="btn btn-success w-100" type="submit">Place Order</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
