<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_to_cart'])) {
    $pid = (int)($_POST['product_id'] ?? 0);
    $qty = max(1, (int)($_POST['qty'] ?? 1));
    if (!isset($_SESSION['cart'][$pid])) {
        $_SESSION['cart'][$pid] = 0;
    }
    $_SESSION['cart'][$pid] += $qty;
    header('Location: cart.php');
    exit;
}

if (isset($_GET['remove'])) {
    $pid = (int)$_GET['remove'];
    unset($_SESSION['cart'][$pid]);
    header('Location: cart.php');
    exit;
}

$cartItems = [];
$total = 0;
if ($_SESSION['cart']) {
    $ids = implode(',', array_map('intval', array_keys($_SESSION['cart'])));
    $stmt = $pdo->query("SELECT * FROM products WHERE id IN ($ids)");
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $map = [];
    foreach ($products as $p) $map[$p['id']] = $p;
    foreach ($_SESSION['cart'] as $pid => $qty) {
        if (!isset($map[$pid])) continue;
        $lineTotal = $map[$pid]['price'] * $qty;
        $total += $lineTotal;
        $cartItems[] = [
            'product' => $map[$pid],
            'qty' => $qty,
            'line_total' => $lineTotal
        ];
    }
}
?>
<div class="container my-4">
    <h3 class="mb-3">Your Cart</h3>
    <?php if (!$cartItems): ?>
        <p class="text-muted">Cart is empty.</p>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table align-middle">
                <thead>
                    <tr>
                        <th>Product</th>
                        <th width="120">Qty</th>
                        <th width="140">Price</th>
                        <th width="140">Line Total</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($cartItems as $item): ?>
                        <tr>
                            <td><?= htmlspecialchars($item['product']['title']) ?></td>
                            <td><?= (int)$item['qty'] ?></td>
                            <td>₹<?= number_format($item['product']['price'], 2) ?></td>
                            <td>₹<?= number_format($item['line_total'], 2) ?></td>
                            <td>
                                <a href="cart.php?remove=<?= $item['product']['id'] ?>" class="btn btn-sm btn-outline-danger">
                                    <i class="bi bi-x"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <tr>
                        <th colspan="3" class="text-end">Total</th>
                        <th>₹<?= number_format($total, 2) ?></th>
                        <th></th>
                    </tr>
                </tbody>
            </table>
        </div>
        <a href="checkout.php" class="btn btn-success">Proceed to Checkout</a>
    <?php endif; ?>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
