<?php include __DIR__ . '/includes/header.php';

$cats = $pdo->query("SELECT id, name FROM categories ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)($_POST['id'] ?? 0);
    $title = trim($_POST['title'] ?? '');
    $sku = trim($_POST['sku'] ?? '');
    $price = floatval($_POST['price'] ?? 0);
    $mrp = floatval($_POST['mrp'] ?? 0);
    $unit = trim($_POST['unit'] ?? '');
    $desc = trim($_POST['description'] ?? '');
    $stock = (int)($_POST['stock'] ?? 0);
    $minStock = (int)($_POST['min_stock'] ?? 0);
    $categoryId = (int)($_POST['category_id'] ?? 0);
    $isActive = isset($_POST['is_active']) ? 1 : 0;

    $imageName = null;
    if (!empty($_FILES['image']['name'])) {
        $uploadDir = __DIR__ . '/../uploads/products/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $imageName = 'prod_' . time() . '_' . mt_rand(1000,9999) . '.' . $ext;
        move_uploaded_file($_FILES['image']['tmp_name'], $uploadDir . $imageName);
    }

    if ($title !== '' && $categoryId) {
        if ($id) {
            if ($imageName) {
                $stmt = $pdo->prepare("UPDATE products SET category_id=?, title=?, sku=?, price=?, mrp=?, unit=?, description=?, stock=?, min_stock=?, is_active=?, image=? WHERE id=?");
                $stmt->execute([$categoryId, $title, $sku, $price, $mrp, $unit, $desc, $stock, $minStock, $isActive, $imageName, $id]);
            } else {
                $stmt = $pdo->prepare("UPDATE products SET category_id=?, title=?, sku=?, price=?, mrp=?, unit=?, description=?, stock=?, min_stock=?, is_active=? WHERE id=?");
                $stmt->execute([$categoryId, $title, $sku, $price, $mrp, $unit, $desc, $stock, $minStock, $isActive, $id]);
            }
        } else {
            $stmt = $pdo->prepare("INSERT INTO products (category_id, title, sku, price, mrp, unit, description, stock, min_stock, is_active, image, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,?, NOW())");
            $stmt->execute([$categoryId, $title, $sku, $price, $mrp, $unit, $desc, $stock, $minStock, $isActive, $imageName]);
        }
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM products WHERE id=?")->execute([$id]);
    header('Location: products.php'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}

$list = $pdo->query("SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON c.id = p.category_id ORDER BY p.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4 class="mb-3">Products</h4>
<div class="row g-3">
    <div class="col-md-5">
        <div class="card p-3">
            <h6 class="card-title mb-2"><?= $edit ? 'Edit Product' : 'Add Product' ?></h6>
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?= htmlspecialchars($edit['id'] ?? '') ?>">
                <div class="mb-2">
                    <label class="form-label small">Title</label>
                    <input class="form-control form-control-sm" name="title" required value="<?= htmlspecialchars($edit['title'] ?? '') ?>">
                </div>
                <div class="row g-2 mb-2">
                    <div class="col-6">
                        <label class="form-label small">Category</label>
                        <select name="category_id" class="form-select form-select-sm" required>
                            <option value="">Select</option>
                            <?php foreach ($cats as $c): ?>
                                <option value="<?= $c['id'] ?>" <?= ($edit['category_id'] ?? '') == $c['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($c['name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-6">
                        <label class="form-label small">SKU</label>
                        <input class="form-control form-control-sm" name="sku" value="<?= htmlspecialchars($edit['sku'] ?? '') ?>">
                    </div>
                </div>
                <div class="row g-2 mb-2">
                    <div class="col-4">
                        <label class="form-label small">Price</label>
                        <input type="number" step="0.01" class="form-control form-control-sm" name="price" value="<?= htmlspecialchars($edit['price'] ?? 0) ?>">
                    </div>
                    <div class="col-4">
                        <label class="form-label small">MRP</label>
                        <input type="number" step="0.01" class="form-control form-control-sm" name="mrp" value="<?= htmlspecialchars($edit['mrp'] ?? 0) ?>">
                    </div>
                    <div class="col-4">
                        <label class="form-label small">Unit</label>
                        <input class="form-control form-control-sm" name="unit" value="<?= htmlspecialchars($edit['unit'] ?? 'kg') ?>">
                    </div>
                </div>
                <div class="row g-2 mb-2">
                    <div class="col-4">
                        <label class="form-label small">Stock</label>
                        <input type="number" class="form-control form-control-sm" name="stock" value="<?= htmlspecialchars($edit['stock'] ?? 0) ?>">
                    </div>
                    <div class="col-4">
                        <label class="form-label small">Min Stock</label>
                        <input type="number" class="form-control form-control-sm" name="min_stock" value="<?= htmlspecialchars($edit['min_stock'] ?? 0) ?>">
                    </div>
                    <div class="col-4">
                        <label class="form-label small">Image</label>
                        <input type="file" class="form-control form-control-sm" name="image">
                    </div>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Description</label>
                    <textarea class="form-control form-control-sm" name="description" rows="2"><?= htmlspecialchars($edit['description'] ?? '') ?></textarea>
                </div>
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= !isset($edit['is_active']) || $edit['is_active'] ? 'checked' : '' ?>>
                    <label class="form-check-label small" for="is_active">Active</label>
                </div>
                <button class="btn btn-success btn-sm w-100" type="submit"><?= $edit ? 'Update' : 'Create' ?></button>
            </form>
        </div>
    </div>
    <div class="col-md-7">
        <div class="card p-3">
            <h6 class="card-title mb-2">All Products</h6>
            <div class="table-responsive small">
                <table class="table table-dark table-sm align-middle">
                    <thead><tr><th>Title</th><th>Category</th><th>Price</th><th>Stock</th><th>Active</th><th></th></tr></thead>
                    <tbody>
                        <?php foreach ($list as $p): ?>
                            <tr>
                                <td><?= htmlspecialchars($p['title']) ?></td>
                                <td><?= htmlspecialchars($p['category_name']) ?></td>
                                <td>₹<?= number_format($p['price'], 2) ?></td>
                                <td><?= (int)$p['stock'] ?></td>
                                <td><?= $p['is_active'] ? 'Yes' : 'No' ?></td>
                                <td>
                                    <a href="?edit=<?= $p['id'] ?>" class="btn btn-outline-light btn-sm">Edit</a>
                                    <a href="?delete=<?= $p['id'] ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete product?')">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (!$list): ?>
                            <tr><td colspan="6" class="text-center text-gray-500">No products yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
