<?php include __DIR__ . '/includes/header.php';

if (isset($_POST['order_id'], $_POST['status'])) {
    $id = (int)$_POST['order_id'];
    $status = $_POST['status'];
    $allowed = ['Pending','Confirmed','Dispatched','Delivered','Cancelled'];
    if (in_array($status, $allowed, true)) {
        $stmt = $pdo->prepare("UPDATE orders SET status=? WHERE id=?");
        $stmt->execute([$status, $id]);
    }
}

$list = $pdo->query("SELECT o.*, u.name AS user_name FROM orders o LEFT JOIN users u ON u.id = o.user_id ORDER BY o.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4 class="mb-3">Orders</h4>
<div class="card p-3">
    <div class="table-responsive small">
        <table class="table table-dark table-sm align-middle">
            <thead><tr><th>#</th><th>Customer</th><th>Total</th><th>Status</th><th>Created</th><th>Change Status</th></tr></thead>
            <tbody>
                <?php foreach ($list as $o): ?>
                    <tr>
                        <td>#<?= $o['id'] ?></td>
                        <td><?= htmlspecialchars($o['user_name']) ?></td>
                        <td>₹<?= number_format($o['cod_amount'], 2) ?></td>
                        <td><span class="badge bg-secondary"><?= htmlspecialchars($o['status']) ?></span></td>
                        <td><?= htmlspecialchars($o['created_at']) ?></td>
                        <td>
                            <form method="post" class="d-flex gap-1 align-items-center">
                                <input type="hidden" name="order_id" value="<?= $o['id'] ?>">
                                <select name="status" class="form-select form-select-sm">
                                    <?php foreach (['Pending','Confirmed','Dispatched','Delivered','Cancelled'] as $st): ?>
                                        <option value="<?= $st ?>" <?= $st===$o['status']?'selected':'' ?>><?= $st ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <button class="btn btn-success btn-sm" type="submit">Update</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (!$list): ?>
                    <tr><td colspan="6" class="text-center text-gray-500">No orders yet.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
