<?php include __DIR__ . '/includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)($_POST['id'] ?? 0);
    $title = trim($_POST['title'] ?? '');
    $type = $_POST['type'] ?? 'article';
    $content = trim($_POST['content'] ?? '');
    $status = $_POST['status'] ?? 'draft';

    if ($title !== '' && $content !== '') {
        if ($id) {
            $stmt = $pdo->prepare("UPDATE knowledge_articles SET title=?, type=?, content=?, status=? WHERE id=?");
            $stmt->execute([$title, $type, $content, $status, $id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO knowledge_articles (title, type, content, status, created_at) VALUES (?,?,?,?, NOW())");
            $stmt->execute([$title, $type, $content, $status]);
        }
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM knowledge_articles WHERE id=?")->execute([$id]);
    header('Location: knowledge.php'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM knowledge_articles WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}

$list = $pdo->query("SELECT * FROM knowledge_articles ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4 class="mb-3">Knowledge Base</h4>
<div class="row g-3">
    <div class="col-md-5">
        <div class="card p-3">
            <h6 class="card-title mb-2"><?= $edit ? 'Edit Article' : 'Add Article' ?></h6>
            <form method="post">
                <input type="hidden" name="id" value="<?= htmlspecialchars($edit['id'] ?? '') ?>">
                <div class="mb-2">
                    <label class="form-label small">Title</label>
                    <input class="form-control form-control-sm" name="title" required value="<?= htmlspecialchars($edit['title'] ?? '') ?>">
                </div>
                <div class="mb-2">
                    <label class="form-label small">Type</label>
                    <select name="type" class="form-select form-select-sm">
                        <?php $typeSel = $edit['type'] ?? 'article'; ?>
                        <option value="article" <?= $typeSel==='article'?'selected':'' ?>>Article</option>
                        <option value="crop" <?= $typeSel==='crop'?'selected':'' ?>>Crop</option>
                        <option value="soil" <?= $typeSel==='soil'?'selected':'' ?>>Soil</option>
                    </select>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Content</label>
                    <textarea class="form-control form-control-sm" name="content" rows="5" required><?= htmlspecialchars($edit['content'] ?? '') ?></textarea>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Status</label>
                    <select name="status" class="form-select form-select-sm">
                        <?php $statusSel = $edit['status'] ?? 'draft'; ?>
                        <option value="draft" <?= $statusSel==='draft'?'selected':'' ?>>Draft</option>
                        <option value="published" <?= $statusSel==='published'?'selected':'' ?>>Published</option>
                    </select>
                </div>
                <button class="btn btn-success btn-sm w-100" type="submit"><?= $edit ? 'Update' : 'Create' ?></button>
            </form>
        </div>
    </div>
    <div class="col-md-7">
        <div class="card p-3">
            <h6 class="card-title mb-2">All Articles</h6>
            <div class="table-responsive small">
                <table class="table table-dark table-sm">
                    <thead><tr><th>Title</th><th>Type</th><th>Status</th><th>Created</th><th></th></tr></thead>
                    <tbody>
                        <?php foreach ($list as $a): ?>
                            <tr>
                                <td><?= htmlspecialchars($a['title']) ?></td>
                                <td><?= htmlspecialchars($a['type']) ?></td>
                                <td><?= htmlspecialchars($a['status']) ?></td>
                                <td><?= htmlspecialchars($a['created_at']) ?></td>
                                <td>
                                    <a href="?edit=<?= $a['id'] ?>" class="btn btn-outline-light btn-sm">Edit</a>
                                    <a href="?delete=<?= $a['id'] ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete article?')">Del</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (!$list): ?>
                            <tr><td colspan="5" class="text-center text-gray-500">No articles yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
