<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../../config/db.php';

if (empty($_SESSION['user']) || strpos($_SESSION['user']['role'], 'admin') === false) {
    header('Location: ' . BASE_URL . 'login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin – <?= APP_NAME ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap & Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #0f172a;
            font-size: 0.9rem;
        }
        .admin-wrapper {
            display: flex;
            min-height: 100vh;
        }
        .sidebar {
            width: 240px;
            background: #020617;
            color: #e5e7eb;
            position: sticky;
            top: 0;
            height: 100vh;
            padding: 1rem 0;
        }
        .sidebar .nav-link {
            color: #9ca3af;
            border-radius: .5rem;
            margin: .15rem .75rem;
            display: flex;
            align-items: center;
            gap: .5rem;
        }
        .sidebar .nav-link.active, .sidebar .nav-link:hover {
            background: #111827;
            color: #fff;
        }
        .sidebar .nav-link i {
            font-size: 1.1rem;
        }
        .sidebar-brand {
            padding: 0 .75rem 1rem;
            margin-bottom: .75rem;
            border-bottom: 1px solid #1f2937;
        }
        .sidebar-brand span {
            font-weight: 700;
        }
        .admin-main {
            flex: 1;
            background: #020617;
            color: #e5e7eb;
        }
        .admin-topbar {
            background: #020617;
            padding: .75rem 1.5rem;
            border-bottom: 1px solid #1f2937;
        }
        .admin-content {
            padding: 1.5rem;
            background: radial-gradient(circle at top left, rgba(34,197,94,0.08), transparent 55%);
        }
        .card {
            background: #020617;
            border: 1px solid #1f2937;
            border-radius: .75rem;
        }
        .card-title {
            font-size: .9rem;
            text-transform: uppercase;
            letter-spacing: .08em;
        }
        .kpi-value {
            font-size: 1.4rem;
            font-weight: 600;
        }
    </style>
</head>
<body>
<div class="admin-wrapper">
    <aside class="sidebar">
        <div class="sidebar-brand d-flex align-items-center justify-content-between px-3">
            <div class="d-flex align-items-center gap-2">
                <span class="badge bg-success-subtle text-success rounded-circle p-2"><i class="bi bi-leaf"></i></span>
                <div>
                    <div class="small text-gray-400">Admin</div>
                    <div><span>Plan &amp; Soil</span></div>
                </div>
            </div>
        </div>
        <nav class="nav flex-column">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF'])==='dashboard.php' ? 'active' : '' ?>" href="dashboard.php">
                <i class="bi bi-speedometer2"></i> <span>Dashboard</span>
            </a>
            <a class="nav-link <?= basename($_SERVER['PHP_SELF'])==='orders.php' ? 'active' : '' ?>" href="orders.php">
                <i class="bi bi-basket"></i> <span>Orders</span>
            </a>
            <a class="nav-link <?= basename($_SERVER['PHP_SELF'])==='products.php' ? 'active' : '' ?>" href="products.php">
                <i class="bi bi-box-seam"></i> <span>Products</span>
            </a>
            <a class="nav-link <?= basename($_SERVER['PHP_SELF'])==='categories.php' ? 'active' : '' ?>" href="categories.php">
                <i class="bi bi-tags"></i> <span>Categories</span>
            </a>
            <a class="nav-link <?= basename($_SERVER['PHP_SELF'])==='soil_types.php' ? 'active' : '' ?>" href="soil_types.php">
                <i class="bi bi-diagram-3"></i> <span>Soil Types</span>
            </a>
            <a class="nav-link <?= basename($_SERVER['PHP_SELF'])==='advisory_rules.php' ? 'active' : '' ?>" href="advisory_rules.php">
                <i class="bi bi-stars"></i> <span>Advisory Rules</span>
            </a>
            <a class="nav-link <?= basename($_SERVER['PHP_SELF'])==='knowledge.php' ? 'active' : '' ?>" href="knowledge.php">
                <i class="bi bi-journal-text"></i> <span>Knowledge Base</span>
            </a>
            <a class="nav-link <?= basename($_SERVER['PHP_SELF'])==='users.php' ? 'active' : '' ?>" href="users.php">
                <i class="bi bi-people"></i> <span>Users</span>
            </a>
        </nav>
        <div class="mt-auto px-3">
            <hr class="border-secondary">
            <div class="small text-gray-500 mb-1">Logged in as</div>
            <div class="small mb-2"><?= htmlspecialchars($_SESSION['user']['name'] ?? 'Admin') ?></div>
            <a href="<?= BASE_URL ?>logout.php" class="btn btn-sm btn-outline-light w-100 mb-2"><i class="bi bi-box-arrow-right me-1"></i>Logout</a>
        </div>
    </aside>
    <main class="admin-main">
        <div class="admin-topbar d-flex justify-content-between align-items-center">
            <div class="small text-gray-400">Admin Dashboard</div>
            <div class="small text-gray-400">Environment: <span class="badge bg-success-subtle text-success">Demo</span></div>
        </div>
        <div class="admin-content">
